           list  off

!
! Assembler source file to perform the resource conversion utility
!
!   No actual conversion performed, but if there were a conversion
!   to perform, it would need to be done in the ReturnDiskSize
!   routine so that the rez mgr would get the correct size and we
!   would need to replace the handle info in the resRefRec we are
!   passed to update the rez mgr on where the data lives
!
!
! Orca/C was't cutting it here sooooo......
!
! Possible converter messages to a resource converter:
!
!          0 - ReadResource
!          2 - WriteResource
!          4 - ReturnDiskSize
!
!          Based on Vol III, AW Version, dated May 1990
!

           case  on
           longa on
           longi on
           mcopy rca.mac

RezAsmConverter  start

my_dp      equ   10                     ;area for my dp

hand_ptr   equ   0
hand       equ   hand_ptr+4

! next equ hand+4

oldStack   equ   my_dp+1
oldDirect  equ   oldStack+2
oldBank    equ   oldDirect+2
retAddr    equ   oldBank+1

resRefPtr  equ   retAddr+3              ;ptr to resRefRec
parm       equ   resRefPtr+4            ;ptr to IORecGS
cmd        equ   parm+4                 ;command from rez
return     equ   cmd+2                  ;return value

           phb
           phd
           tsc
           pha
           phk
           plb

           tsc
           sec
           sbc   #my_dp                 ;make some room
           tcd
           tcs                          ;and move the stack down
           pha                          ;just in case

! Zap the return vals...

           stz   return
           stz   return+2

           ldx   cmd
           cpx   #5
           bge   bail
           lda   JmpTable,x
           pha
           rts

JmpTable   dc    a"ReadResource-1"
           dc    a"WriteResource-1"
           dc    a"ReturnDiskSize-1"

bail       jml   xit               ; too big mon

! Gets the size from our handle, and tell the res mgr about it

ReturnDiskSize anop

           pea   0
           pea   0
           ldy   #$10+2
           lda   [resRefPtr],y
           pha
           dey
           dey
           lda   [resRefPtr],y
           pha
           _GetHandleSize
           pla
           sta   return
           pla
           sta   return+2
           brl   xit

! Write the resource to disk, must return no errors according to
! Resource Manager chapter.

WriteResource anop

           ldy   #$10+2            ; get the handle & lock
           lda   [resRefPtr],y
           sta   hand+2
           pha
           dey
           dey
           lda   [resRefPtr],y
           sta   hand
           pha
           _HLock

           ldy   #0                ; get a ptr from handle
           lda   [hand],y
           sta   hand_ptr
           ldy   #2
           lda   [hand],y
           sta   hand_ptr+2

           lda   #3                ; set up PositionRec
           sta   PositionRec
           ldy   #2                ; ref num
           lda   [parm],y
           sta   PositionRec+2
           lda   #0                ; base info
           sta   PositionRec+4
           ldy   #6                ; position we need - resOffset
           lda   [resRefPtr],y
           sta   PositionRec+6
           iny
           iny
           lda   [resRefPtr],y
           sta   PositionRec+8

           _SetMarkGS PositionRec

           lda   parm
           sta   ioPtr
           lda   parm+2
           sta   ioPtr+2
           jsl   $E100A8           ; Do the write using the passed IORec Ptr
           dc    i2"$2013"
ioPtr      dc    i4"ioPtr"         ; this gets replaced

           PushLong hand
           _HUnlock

           brl   xit

! This would be the place to implement a read converter if you need
! one in your own code.

ReadResource anop             ;not implemented in this converter

xit        anop

           lda   retAddr
           sta   return-3
           lda   retAddr+1
           sta   return-2
           lda   oldStack
           tcs
           pld                     ; restore banks
           plb
           tsc
           clc
           adc   #(cmd+2-resRefPtr)
           tcs
           lda   #0
           rtl

PositionRec  ds  10                ; set up here

           end
